/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg;

import frc.emul.psg.DacOutputLine;
import frc.emul.psg.IAudioSettings;
import frc.emul.psg.IExtraAudioLine;
import frc.emul.psg.IPsgCore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AudioLine {
    private static final boolean TRACE = true;
    private final DacOutputLine dacOutput;
    private float sampleRate;
    private int samplesPU;
    private int updatesPS;
    private int bufferSize;
    private byte[] wave;
    private int[] buffer;
    private int[] extra;
    private int lineBufferSize;
    private SourceDataLine dataLine;
    private boolean mute;

    public AudioLine(DacOutputLine dacOutputLine, IAudioSettings iAudioSettings) {
        this.dacOutput = dacOutputLine;
        this.updateSettings(iAudioSettings);
    }

    public final void updateSettings(IAudioSettings iAudioSettings) {
        boolean bl;
        int n = iAudioSettings.getSampleRate();
        int n2 = iAudioSettings.getUpdatesPerSecond();
        int n3 = n / n2 + 2;
        this.dacOutput.updateSettings(iAudioSettings, n3);
        if (n == (int)this.sampleRate && n2 == this.updatesPS) {
            return;
        }
        boolean bl2 = bl = this.getDataLine() != null;
        if (bl) {
            this.shutdown();
        }
        this.sampleRate = n;
        this.updatesPS = n2;
        this.samplesPU = n3;
        this.bufferSize = n3 * 2;
        this.buffer = new int[n3];
        this.extra = new int[n3];
        this.wave = new byte[this.bufferSize];
        this.lineBufferSize = this.bufferSize;
        if (bl) {
            this.initialise();
        }
    }

    public final boolean isMute() {
        return this.mute;
    }

    public final synchronized void setMute(boolean bl) {
        if (bl != this.mute) {
            this.mute = bl;
            if (bl) {
                if (this.getDataLine() != null) {
                    this.shutdown();
                }
            } else if (this.getDataLine() == null) {
                this.initialise();
            }
        }
    }

    public final synchronized void reset() {
        this.dacOutput.deactivate();
        this.clear();
    }

    public final synchronized void clear() {
        if (this.dataLine != null) {
            this.dataLine.stop();
            this.dataLine.flush();
            this.dataLine.start();
        }
    }

    public final synchronized boolean initialise() {
        if (this.mute) {
            return true;
        }
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, 1, 2, this.sampleRate, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, this.lineBufferSize);
        if (!AudioSystem.isLineSupported(info)) {
            System.err.println("Unsupported audio format: " + audioFormat);
            return false;
        }
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.dataLine.open(audioFormat, this.lineBufferSize);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Data Line not available for audio format: " + audioFormat);
            this.dataLine = null;
            return false;
        }
        this.dataLine.start();
        System.out.println("Audio Line initialised : " + audioFormat);
        System.out.println(" - Sample rate ...... " + this.sampleRate);
        System.out.println(" - Updates/Second ... " + this.updatesPS);
        System.out.println(" - Samples/Update ... " + this.samplesPU);
        System.out.println(" - Line Buffer ...... " + this.dataLine.getBufferSize() + " bytes");
        if (this.bufferSize != this.dataLine.getBufferSize()) {
            System.out.println(" - Chip Buffer ...... " + this.bufferSize + " bytes");
        }
        return true;
    }

    public final SourceDataLine getDataLine() {
        return this.dataLine;
    }

    public final synchronized void shutdown() {
        if (this.dataLine != null) {
            System.out.println("Audio Line shutdown ...");
            if (this.dataLine.isRunning()) {
                this.dataLine.stop();
                this.dataLine.flush();
            }
            if (this.dataLine.isOpen()) {
                this.dataLine.close();
            }
            this.dataLine = null;
        }
    }

    public final synchronized void render(float f, IPsgCore iPsgCore, IExtraAudioLine iExtraAudioLine) {
        if (this.mute || this.dataLine == null) {
            return;
        }
        int n = this.dataLine.available() / 2;
        int n2 = (int)(f * this.sampleRate);
        n2 = Math.min(n2, this.bufferSize >> 1);
        if ((n2 = Math.min(n2, n)) <= 0) {
            return;
        }
        iPsgCore.feed(this.buffer, 0, n2);
        this.dacOutput.merge(this.buffer, 0, n2);
        if (iExtraAudioLine != null) {
            iExtraAudioLine.feed(this.extra, 0, n2);
            int n3 = n2 - 1;
            while (n3 >= 0) {
                int n4 = this.buffer[n3];
                int n5 = this.extra[n3];
                int n6 = (n4 / 2 + n5 / 2) / 2;
                this.wave[2 * n3] = (byte)(n6 >> 8);
                this.wave[2 * n3 + 1] = (byte)n6;
                --n3;
            }
        } else {
            int n7 = n2 - 1;
            while (n7 >= 0) {
                int n8 = this.buffer[n7];
                this.wave[2 * n7] = (byte)(n8 >> 8);
                this.wave[2 * n7 + 1] = (byte)n8;
                --n7;
            }
        }
        this.dataLine.write(this.wave, 0, n2 * 2);
    }
}

